/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-18
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DINVERFORTRAN_H
#define DINVERFORTRAN_H

#ifndef __cplusplus
#  error
#endif

#include "AbstractForward.h"
#include "DinverInterface.h"

namespace DinverCore {

extern "C" {

class AbstractForward;

typedef AbstractForward * DinverForward;

const char * dinver_plugin_tag();
const char * dinver_plugin_title();
const char * dinver_plugin_version();
const char * dinver_plugin_description();

void dinver_init_global_();
void dinver_init_run_(DinverForward run);
void dinver_forward_(int * nd, float * model, int * ok, float * misfit);

void dinver_set_parameter_count_(DinverForward forward, int * n);
void dinver_set_range_(DinverForward forward, int * paramIndex, float * min, float * max, int * scale, float * precision);
void dinver_add_less_than_condition_(DinverForward forward, int * p1Index, float * a, int * p2Index, float * b);
void dinver_add_greater_than_condition_(DinverForward forward, int * p1Index, float * a, int * p2Index, float * b);
}

} // namespace DinverCore

#endif // DINVERFORTRAN_H
