/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-05
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DINVERCOREENGINE_H
#define DINVERCOREENGINE_H

#include <QGpCoreTools.h>

#include "DinverCoreDLLExport.h"

namespace QGpGuiTools {
  class MultiDocumentSubWindow;
}
using namespace QGpGuiTools;

namespace DinverCore {

  class AbstractForward;

  class DinverInterface;
  class DINVERCORE_EXPORT DinverCoreEngine : public GlobalObject
  {
    TRANSLATIONS("DinverCoreEngine")
  public:
    DinverCoreEngine();
    virtual ~DinverCoreEngine();

    static DinverCoreEngine * instance() {return _self;}

    virtual MultiDocumentSubWindow * addSubWindow(QWidget * parent, QWidget * w);
    virtual void removeSubWindow(QWidget * w);
    virtual void activateSubWindow(QWidget * w);

    virtual QStringList selectedReports(QWidget *parent,const QString& title) const;
    virtual QList<const AbstractForward *> forwardList(QWidget *parent, const QStringList& reports) const;

    virtual bool useProgress() {return false;}
    virtual void setProgressMaximum(QWidget * parent, int value) {Q_UNUSED(parent) Q_UNUSED(value)}
    virtual int progressMaximum(QWidget * parent) {Q_UNUSED(parent) return 0;}
    virtual void setProgressValue(QWidget * parent, int value ) {Q_UNUSED(parent) Q_UNUSED(value)}
    //virtual AbstractProgress * progress(QWidget * parent) {Q_UNUSED(parent) return 0;}
    virtual void showMessage(QWidget * parent, QString msg) {Q_UNUSED(parent) Q_UNUSED(msg)}

    virtual bool isModified(QObject * parent) const {Q_UNUSED(parent) return false;}
    virtual void setModified(QObject * parent, bool m) {Q_UNUSED(parent) Q_UNUSED(m)}

    bool setDefaultPlugin(QString pluginFile, bool debug);
    DinverInterface * defaultPlugin() const {return _plugin;}

    static DinverInterface * loadPlugin(QString pluginFile, bool debug);
    static void printPluginList();
    static QStringList defaultPluginPaths();
    static QString pluginFile(QString tag, bool debug);
  private:
    DinverInterface * _plugin;
    static DinverCoreEngine * _self;
  };

  class DINVERCORE_EXPORT DinverPluginSettings : public PluginSettings
  {
  public:
    DinverPluginSettings();

    void setDefaultPlugin(int i);
    int defaultPlugin() const;
  };

} // namespace Dinvercore

#endif // DINVERCOREENGINE_H
