/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-01-05
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef RINGPAIRS_H
#define RINGPAIRS_H

#include <GeopsyCore.h>
#include <QGpCoreWave.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class StationPair;
  class SPACCrossSpectrum;

  class ARRAYCORE_EXPORT RingPairs: public QVector<const StationPair *>, public AutocorrRing
  {
  public:
    RingPairs() : AutocorrRing() {_weights=nullptr;}
    RingPairs(double rMin, double rMax) : AutocorrRing(rMin, rMax) {_weights=nullptr;}
    RingPairs(const AutocorrRing& o) : AutocorrRing(o) {_weights=nullptr;}
    RingPairs(const RingPairs& o);
    virtual ~RingPairs();

    void operator=(const RingPairs& o);

    bool setStations(const QVector<StationPair>& stationPairs);
    QString toString() const;
    QString name() const {return QString( "(%1 m, %2 m)" ).arg(minRadius()).arg(maxRadius());}
    double weight(int index) const {return _weights[index];}

    Complex verticalAutocorr(const SPACCrossSpectrum * crossSpectrum) const;
    Complex radialAutocorr(const SPACCrossSpectrum * crossSpectrum) const;
    Complex transverseAutocorr(const SPACCrossSpectrum * crossSpectrum) const;
  private:
    static bool lessThan(const StationPair * s1, const StationPair * s2);

    double * _weights;
  };

} // namespace ArrayCore

#endif // RINGPAIRS_H
