/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-09-05
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "StationItem.h"
#include "Station.h"

/*!
  \class StationItem StationItem.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
StationItem::StationItem(QObject * parent)
  : QAbstractTableModel(parent)
{
  TRACE;
  _stations=0;
  _lastUpdate.start();
}

/*!
  Description of destructor still missing
*/
StationItem::~StationItem()
{
  TRACE;
}

void StationItem::setStations(QList<Station *> * stations)
{
  TRACE;
  beginResetModel();
  _stations=stations;
  for(QList<Station *>::iterator it=_stations->begin(); it!=_stations->end(); it++) {
    disconnect(*it, SIGNAL(dataChanged(int)), this, SLOT(stationChanged(int)));
    connect(*it, SIGNAL(dataChanged(int)), this, SLOT(stationChanged(int)));
  }
  endResetModel();
}

int StationItem::rowCount(const QModelIndex&) const
{
  TRACE;
  if(_stations) {
    return _stations->count();
  } else {
    return 0;
  }
}

int StationItem::columnCount(const QModelIndex&) const
{
  TRACE;
  return 11;
}

QVariant StationItem::data(const QModelIndex & index, int role) const
{
  TRACE;
  Station * s=_stations->at(index.row());
  switch(role) {
  case Qt::DisplayRole:
    switch(index.column()) {
    case 0:
      return s->name();
    case 1:
      if(s->frequency()>0) {
        return QString::number(s->frequency())+" Hz";
      }
      break;
    case 2:
      if(s->hardwareGain()>0) {
        return "*"+ QString::number(s->hardwareGain());
      }
      break;
    case 3:
      if(s->numberOfBits()>0) {
        return QString::number(s->numberOfBits())+" bits";
      }
      break;
    case 4:
      return s->seismicState();
    case 5:
      return s->gpsState();
    case 6:
      if(s->diskSpace()>0.0) {
        double sp=s->diskSpace();
        if(sp>1024) {
          return QString::number(sp/(1024.0*1024.0), 'f', 3)+" GiB";
        } else {
          return QString::number(sp/1024.0, 'f', 0)+" MiB";
        }
      }
      break;
    case 7:
      return s->internalBattery();
    case 8:
      return s->externalBattery();
    case 9:
      return s->temperature();
    case 10:
      return s->buddies();
    default:
      break;
    }
    break;
  case Qt::ToolTipRole:
    return s->linkState();
  default:
    break;
  }
  return QVariant();
}

QVariant StationItem::headerData(int section, Qt::Orientation orientation, int role) const
{
  TRACE;
  if(orientation==Qt::Horizontal && role==Qt::DisplayRole) {
    switch(section) {
    case 0: return tr("Name");
    case 1: return tr("Frequency");
    case 2: return tr("Gain");
    case 3: return tr("Resolution");
    case 4: return tr("Seismic");
    case 5: return tr("GPS");
    case 6: return tr("Disk space");
    case 7: return tr("Int. battery");
    case 8: return tr("Ext. battery");
    case 9: return tr("Temperature");
    case 10: return tr("Buddies");
    default:
      break;
    }
  }
  return QVariant();
}

Qt::ItemFlags StationItem::flags(const QModelIndex& index) const
{
  TRACE;
  if(_stations->at(index.row())->isAvailable()) {
    return Qt::ItemIsSelectable | Qt::ItemIsEnabled;
  } else {
    return Qt::NoItemFlags;
  }
}

void StationItem::stationChanged(int stationIndex)
{
  TRACE;
  _toUpdate.insert(stationIndex);
  if(_lastUpdate.elapsed()>1000) {
    for(QSet<int>::iterator it=_toUpdate.begin(); it!=_toUpdate.end(); it++) {
      emit dataChanged(createIndex(*it, 0), createIndex(*it, 10));
    }
    _toUpdate.clear();
    _lastUpdate.start();
  }
}
