/***************************************************************************
**
**  This file is part of vslarray.
**
**  vslarray is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  vslarray is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-24
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ACQUISITIONSIGNALS_H
#define ACQUISITIONSIGNALS_H

#include <GeopsyCore.h>

class AcquisitionSignals : public QObject, public StationProcessSignals
{
  Q_OBJECT
public:
  AcquisitionSignals(const StationSignals * originalSignals, double timeScale=1.0);
  ~AcquisitionSignals();

  void start(double delay);
  void stop();

  void setSignalStartTime(const DateTime& t) {_signalStartTime=t;}
  void setPlayStartTime(const DateTime& t) {_playStartTime=t;}
  virtual bool setProcessed(const TimeRange& tw, const AbstractParameters * param);

  bool isActive() const {return _timer ? _timer->isActive() : false;}
  bool isOn() const {return _on;}
  void setOn(bool o) {_on=o;}
private slots:
  void sendSignals();
private:
  void save(const DateTime& startTime, const QString& fileNameSuffix);
  //void save(int iStart, int iEnd, double deltaT, double t0, const QString& fileNameSuffix);

  bool _on;
  double _delay;
  QTimer * _timer;
  DateTime _signalStartTime;
  DateTime _playStartTime;
  double _timeScale;
  DateTime _lastSentTime;
  //int _lastSendIndex;
};

#endif // ACQUISITIONSIGNALS_H
