/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-06-01
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**    Miriam Kristekova (Geophysical Institute, Academy of Sciences, Bratislava, Slovak Republic)
**
***************************************************************************/

#ifndef HVTFAPARAMETERS_H
#define HVTFAPARAMETERS_H

#include <GeopsyCore.h>

class HVTFAParameters: public AbstractParameters
{
public:
  HVTFAParameters();
  HVTFAParameters(const HVTFAParameters& o);

  virtual AbstractParameters * clone() const;

  const TimeRangeParameters& timeRange() const {return _timeRange;}
  TimeRangeParameters& timeRange() {return _timeRange;}
  void setTimeRange(const TimeRangeParameters& t) {_timeRange=t;}

  const SamplingParameters& frequencySampling() const {return _frequencySampling;}
  SamplingParameters& frequencySampling() {return _frequencySampling;}
  void setFrequencySampling(const SamplingParameters& f) {_frequencySampling=f;}

  const MorletParameters& wavelet() const {return _wavelet;}
  MorletParameters& wavelet() {return _wavelet;}
  void setWavelet(const MorletParameters& w) {_wavelet=w;}

  const QDir& outputDirectory() const {return _outputDirectory;}
  void setOutputDirectory(const QDir& o) {_outputDirectory=o;}

  virtual QString toString(PARAMETERS_TOSTRING_ARGS_DECL) const;
  virtual void setVersion(PARAMETERS_SETVERSION_ARGS);
  virtual void collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS);
protected:
  virtual int keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const;
  virtual bool setValue(PARAMETERS_SETVALUE_ARGS);
private:
  TimeRangeParameters _timeRange;
  SamplingParameters _frequencySampling;
  MorletParameters _wavelet;
  QDir _outputDirectory;
};

#endif // HVTFAPARAMETERS_H
