/***************************************************************************
**
**  This file is part of gpviewmax.
**
**  gpviewmax is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpviewmax is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-07-16
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreMath.h>

#include "Sample.h"

/*!
  \class Sample Sample.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

Sample::Sample()
{
  _time=0.0;
  _frequency=0.0;
  _slowness=0.0;
  _azimuth=0.0;
  _ellipticity=0.0;
  _noise=0.0;
  _power=0.0;
}

Sample::Sample(const Sample& s)
{
  _time=s._time;
  _frequency=s._frequency;
  _slowness=s._slowness;
  _azimuth=s._azimuth;
  _ellipticity=s._ellipticity;
  _noise=s._noise;
  _power=s._power;
}

/*!
  Read and parse next available not blank and not starting with '#',
  and containing \a pattern. Non-valid samples are ignored.
*/
bool Sample::read(const QString& line)
{
  TRACE;
  bool ok=true;
  LineParser lp(line);
  _time=lp.toDouble(0, ok);
  _frequency=lp.toDouble(1, ok);
  _slowness=lp.toDouble(3, ok);
  _azimuth=lp.toDouble(4, ok);
  _ellipticity=Angle::radiansToDegrees(::atan(lp.toDouble(5, ok)));
  _noise=lp.toDouble(6, ok);
  _power=lp.toDouble(7, ok);
  bool valid=(lp.toInt(8, ok)==1);
  if(ok) {
    return valid;
  } else {
    App::log(tr("Error parsing line '%1'\n").arg(line));
    return false;
  }
}


void Sample::write(QTextStream& s, const QString& polarization) const
{
  TRACE;
  s <<  _time << " " << _frequency << " " << polarization << " "
     << _slowness << " "
     << _azimuth << " "
     << ::tan(Angle::degreesToRadians(_ellipticity)) << " "
     << _noise << " "
     << _power << " 1\n";
}


