/***************************************************************************
**
**  This file is part of gpparam2model.
**
**  gpparam2model is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpparam2model is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-06-03
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MODELGENERATOR_H
#define MODELGENERATOR_H

#include <DinverCore.h>
#include <DinverDCCore.h>

class ModelGenerator : public AbstractForward
{
  TRANSLATIONS("ModelGenerator")
public:
  ModelGenerator();
  ~ModelGenerator();

  bool setParamSpace(ParamGroundModel * gm);

  AbstractForward * clone() const;
  virtual double misfit(bool& ok);
  inline virtual void valueChanged(const Parameter * from=0);
  inline bool isFussyOk(const Parameter * from);
private:
  ParamGroundModel * _paramModel;
  ParamProfile * _vp, * _vs, * _rho, * _nu;
  PoissonCondition * _poissonCondition;
};

inline void ModelGenerator::valueChanged(const Parameter * from)
{
  _paramModel->updateFinalProfiles(static_cast<const GroundParameter *>(from));
  _poissonCondition->setVp(); // For constant Nu only
}

inline bool ModelGenerator::isFussyOk(const Parameter * from)
{
  if(_poissonCondition)
    return _poissonCondition->isOk(static_cast<const GroundParameter *>(from));
  else
    return true;
}

#endif // MODELGENERATOR_H
