/***************************************************************************
**
**  This file is part of gpgridsearch.
**
**  gpgridsearch is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpgridsearch is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-04-25
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef WORKERLOOP_H
#define WORKERLOOP_H

#include <QGpCoreTools.h>

#include "GridGenerator.h"

class Reader;

class WorkerLoop : public ParallelLoop
{
public:
  WorkerLoop(const Reader * p);
  ~WorkerLoop();

  void start();
protected:
  virtual LoopWorker * newWorker();
private:
  const Reader * _parameters;
  GridGenerator * _generator;
};

#endif // WORKERLOOP_H
