/***************************************************************************
**
**  This file is part of gpgridsearch.
**
**  gpgridsearch is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpgridsearch is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-04-25
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ModelWorker.h"
#include "WorkerLoop.h"
#include "Reader.h"

/*!
  \class WorkerLoop WorkerLoop.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
WorkerLoop::WorkerLoop(const Reader * p)
{
  TRACE;
  _parameters=p;
  _generator=0;
}

/*!
  Description of destructor still missing
*/
WorkerLoop::~WorkerLoop()
{
  TRACE;
  delete _generator;
}

void WorkerLoop::start()
{
  TRACE;
  _generator=new GridGenerator(_parameters->parameterSpace().variableParameterCount(), _parameters->values());
  _generator->setSubsetIndex(Thread::idealThreadCount());
  App::log(tr("Starting grid search with...\n"
                      "  %1 forward computations,\n"
                      "  %2 sub tasks\n"
                      "  distributed on %3 threads.\n")
                   .arg(_generator->count()).arg(_generator->subsetCount()).arg(Thread::idealThreadCount()));
  ParallelLoop::start(0, _generator->subsetCount(), false);
}

LoopWorker * WorkerLoop::newWorker()
{
  ModelWorker * t=new ModelWorker(_parameters, _generator);
  return t;
}
