/***************************************************************************
**
**  This file is part of geopsynr.
**
**  geopsynr is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsynr is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-06
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TOOLNR_H
#define TOOLNR_H

#include <GeopsyGui.h>

class ToolNRd;
class ShotRecord;

class ToolNR : public AbstractToolWidget
{
  Q_OBJECT
public:
  ToolNR(QWidget * parent);
  ~ToolNR();
public slots:
  void t0Apply();
  void t0Revert();
  void uniformStack();
  void optimizeStack();
  void highlightShot(int shotIndex);
  void newGraphicViewer();
protected:
  virtual bool initStations(SubSignalPool * subPool);
  virtual void updateAllFields();
private:
  void shotsToSubPool();

  ToolNRd * _d;
  QList<ShotRecord *> _shots;
  SubSignalPool _stack;
  void showStackResults();
};

#endif // TOOLNR_H
