/***************************************************************************
**
**  This file is part of geopsynr.
**
**  geopsynr is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsynr is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef T0GRIDSEARCH_H
#define T0GRIDSEARCH_H

#include <QGpCoreTools.h>
#include "T0Correlation.h"

class T0GridSearch : public GridSearch
{
public:
  inline void setGrid(double dt);

  void setFunction(T0Correlation * f) {_function=f;}
  T0Correlation * function() const {return static_cast<T0Correlation *>(_function);}

  double bestShift() const {return _pos.x();}
};

inline void T0GridSearch::setGrid(double dt)
{
  TRACE;
  GridSearch::setGrid(-10.0*dt, 10*dt, dt, 0.0, 0.0, 1);
  setAbsolutePrecision(0, dt*0.01);
}

#endif // T0GRIDSEARCH_H
