/***************************************************************************
**
**  This file is part of geopsynr.
**
**  geopsynr is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsynr is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-06
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SHOTRECORD_H
#define SHOTRECORD_H

#include <GeopsyCore.h>

class ShotRecord
{
public:
  ShotRecord(const SeismicEvent * source);
  ~ShotRecord();

  bool setSubPool(SubSignalPool * subPool);

  bool isSameReceiverSet(const ShotRecord& o) const;
  int receiverIndex(double distance) const;
  SubSignalPool * receivers() const {return _subPool;}
  void shift(double dt);
  void revert();
private:
  SignalProcess * _process;
  SubSignalPool * _subPool;
  const SeismicEvent * _source;
};

#endif // SHOTRECORD_H
