/***************************************************************************
**
**  This file is part of geopsynr.
**
**  geopsynr is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsynr is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-06
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyCore.h>
#include "ShotRecord.h"

/*!
  \class ShotRecord ShotRecord.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description still missing
*/
ShotRecord::ShotRecord(const SeismicEvent * source)
{
  TRACE;
  _process=nullptr;
  _source=source;
  _subPool=nullptr;
}

/*!
  Description still missing
*/
ShotRecord::~ShotRecord()
{
  TRACE;
  delete _process;
  delete _subPool;
}


bool ShotRecord::setSubPool(SubSignalPool * subPool)
{
  TRACE;
  _subPool=subPool;
  if(_subPool->isEmpty()) {
    return false;
  }
  int n=subPool->count();
  DateTime refStartTime=_subPool->first()->startTime();
  double refSampPeriod=_subPool->first()->samplingPeriod();
  int refNSamples=_subPool->first()->nSamples();
  for(int i=1; i<n; i++) {
    Signal * sig=_subPool->at(i);
    if(sig->startTime()!=refStartTime ||
       sig->samplingPeriod()!=refSampPeriod  ||
       sig->nSamples()!=refNSamples) {
      return false;
    }
  }
  _process=new SignalProcess;
  _process->setCurrentSubPool(_subPool);
  _subPool->setName(refStartTime.toString("hhmmss"));
  return true;
}

bool ShotRecord::isSameReceiverSet(const ShotRecord& o) const
{
  TRACE;
  if(_subPool->count()!=o._subPool->count()) return false;
  for(int i =_subPool->count()-1; i>=0; i-- ) {
    if(_subPool->at(i)->receiver()!=o._subPool->at(i)->receiver()) return false;
  }
  return true;
}

/*!
  Return the receiver index with a receiver-source distance just less than \a distance.
*/
int ShotRecord::receiverIndex(double distance) const
{
  TRACE;
  for(int i=_subPool->count()-1; i>=0; i-- ) {
    if(_source->position().distanceTo(_subPool->at(i)->receiver())<distance) {
      return i;
    }
  }
  return -1;
}

void ShotRecord::shift(double dt)
{
  TRACE;
  _process->shift(dt);
}

void ShotRecord::revert()
{
  TRACE;
  _process->restoreStep(0);
  _process->clear();
}

