/***************************************************************************
**
**  This file is part of geopsyfigs.
**
**  geopsyfigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyfigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-03-23
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GEOPSYFIGS_H
#define GEOPSYFIGS_H

#include <SciFigs.h>
#include <SciFigsVersion.h>

#include "geopsyfigsInstallPath.h"

class GeopsyFigs : public SciFigsPlugin
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.SciFigsInterface")
#endif
  Q_INTERFACES(SciFigs::SciFigsPlugin)
public:
  virtual QString tag() const {return "geopsygui";}
  virtual QString title() const {return tr("Signal viewer based on Geopsy database");}

  virtual const char * interfaceVersion() const {return SCIFIGS_VERSION;}
};

#endif // GEOPSYFIGS_H
