/***************************************************************************
**
**  This file is part of geopsydamping.
**
**  geopsydamping is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsydamping is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-11-14
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <GeopsyGui.h>

#include "ToolDamping.h"
#include "ToolDampingd.h"
#include "DampingResults.h"
#include "Parameters.h"

#define _dampingRes ((DampingResults*)_childrenList[0])

ToolDamping::ToolDamping(QWidget * parent) :
  AbstractToolWidget(parent, 1)
{
  TRACE;
  QVBoxLayout * baseLayout=new QVBoxLayout(this);
  _d=new ToolDampingd(this);
  baseLayout->addWidget(_d);

  setWindowTitle("Damping toolbox");
  setObjectName("ToolDamping");
  connect(_d->startBut,SIGNAL(clicked()),this,SLOT(start()));
  connect(_d->reLoadParam,SIGNAL(clicked()),this,SLOT(loadLogParameters()));
}

void ToolDamping::updateAllFields()
{
  TRACE;
  _d->on_doFilterBut_stateChanged();
  _d->filterWidget->updateAllFields();
  _d->timeLimits->updateAllFields();
}

bool ToolDamping::setSubPool(SubSignalPool * subPool)
{
  TRACE;
  AbstractToolWidget::setSubPool(subPool);
  // For future when tool class will be implemented
  //_d->timeLimits->setSubPool(_tool->subPool());
  return true;
}

bool ToolDamping::initStations(SubSignalPool *subPool)
{
  TRACE;
  _subPool=subPool;
  _d->timeLimits->setSubPool(_subPool);
  return true;
}

void ToolDamping::start()
{
  TRACE;
  SignalDatabase * db=_subPool->database();
  if(!_dampingRes) {
    _childrenList[0]=new DampingResults;
    _dampingRes->createObjects(_subPool);
    QString str="Damping results - ";
    str+=_subPool->name();
    _dampingRes->setWindowTitle(str);
    GeopsyGuiEngine::instance()->addSubWindow(this, _dampingRes)->setUserClosable(false);
  }
  // Get parameters
  Parameters * param=static_cast<Parameters *>(parameters());
  // Use index rather than _subPool, as signals may have been added to subpool
  // We are not processing them here.
  int nSig=_subPool->count();
  GeopsyCoreEngine::instance()->setProgressMaximum(db, nSig);
  for(int i=0;i<nSig;i++) {
    GeopsyCoreEngine::instance()->setProgressValue(db, i);
    if(!_dampingRes->compute(i, _subPool->at(i), *param)) break;
  }
  delete param;
  GeopsyCoreEngine::instance()->setProgressValue(db, nSig);
}

AbstractParameters * ToolDamping::parameters(AbstractParameters * param) const
{
  TRACE;
  if(!param) {
    param=new Parameters;
  }
  _d->getParameters(*static_cast<Parameters *>(param));
  return param;
}


void ToolDamping::setParameters(const AbstractParameters * param)
{
  TRACE;
  _d->setParameters(*static_cast<const Parameters *>(param));
}
