/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef VIEWPARAMEDITOR_H
#define VIEWPARAMEDITOR_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <GeopsyCore.h>
#include "ui_ViewParamEditor.h"


class ViewParamDelegate : public QItemDelegate
{
  Q_OBJECT
public:
  ViewParamDelegate(QObject *parent=0);

  QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &option,
                        const QModelIndex &index) const;
  void setEditorData(QWidget *editor, const QModelIndex &index) const;
  void setModelData(QWidget *editor, QAbstractItemModel *model,
                      const QModelIndex &index) const;
private slots:
  void commit();
private:
  QStringList _tableFieldList;
};

class ViewParamEditor : public QWidget, public Ui::ViewParamEditor
{
  Q_OBJECT
public:
  ViewParamEditor(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);

  void initTableFields(const MetaDataFieldList & sel);
  void getTableFields(MetaDataFieldList & sel);
public slots:
  void on_addTableField_clicked();
  void on_removeTableField_clicked();
  void on_insertTableField_clicked();
  void on_selFieldList_itemChanged(QTableWidgetItem * item);
  void on_fieldTemplate_currentIndexChanged(int index);
private:
  void setIndexState(QTableWidgetItem * item, const MetaDataIndex& index);
};

#endif // VIEWPARAMEDITOR_H
