/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-04-05
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAPWINDOW_H
#define MAPWINDOW_H

#include <GeopsyGui.h>

class MapWindow : public SubPoolWindow
{
  Q_OBJECT
public:
  MapWindow(QWidget* parent=0);
  ~MapWindow();

  virtual void setWindowTitle(QString title);
  virtual void subPoolUpdate();
  virtual void endSignalChange(Signal * sig=0);
  virtual void fastFourierTransform(DoubleSignal::SignalType st);

  void setLimits();
public slots:
  void getSelection(SubSignalPool& sel);
  void selectFromCoordinates();
protected:
  ArrayMap * _map;
};

#endif
