/***************************************************************************
**
**  This file is part of dinverext.
**
**  dinverext is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverext is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "ExtTargetWidget.h"
#include "ExtTarget.h"

/*!
  \class ExtTargetWidget ExtTargetWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ExtTargetWidget::ExtTargetWidget(QWidget * parent)
    : QWidget(parent)
{
  TRACE;
  setupUi(this);
}

/*!
  Description of destructor still missing
*/
ExtTargetWidget::~ExtTargetWidget()
{
  TRACE;
}

void ExtTargetWidget::on_wdBut_clicked()
{
  TRACE;
  QString dirName=wdEdit->text();
  dirName=Message::getExistingDirectory(tr("Working directory for external command"),dirName);
  if(!dirName.isEmpty()) {
    wdEdit->setText(dirName);
  }
}

ExtTarget * ExtTargetWidget::target()
{
  TRACE;
  ExtTarget * s=new ExtTarget;
  s->setCommand(commandEdit->text());
  s->setWorkingDirectory(wdEdit->text());
  return s;
}

void ExtTargetWidget::setFrom(ExtTarget * target)
{
  TRACE;
  commandEdit->setText(target->command());
  wdEdit->setText(target->workingDirectory());
}

void ExtTargetWidget::setEditable(bool e)
{
  TRACE;
  commandEdit->setReadOnly( !e);
  wdEdit->setReadOnly( !e);
  wdBut->setEnabled(e);
}
