/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-08-08
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REFRACTIONTARGETWIDGET_H
#define REFRACTIONTARGETWIDGET_H

#include <QGpGuiMath.h>
#include <QGpCoreWave.h>

class RefractionTargetWidget : public CurveBrowser, public WidgetRect
{
  Q_OBJECT
public:
  RefractionTargetWidget(QWidget* parent=0);
  ~RefractionTargetWidget();

  QList<RefractionCurve> curves() const;
  void addCurve(const RefractionCurve& curve);
  void addCurves(const QList<RefractionCurve>& curves);
protected:
  void resizeEvent(QResizeEvent * e);
protected slots:
  virtual void on_curveScroll_valueChanged(int v);
  virtual void setLimits();
  void sourceChanged(double loc);
private:
  RefractionCurve& curve(int index) const;

  QLabel * _sourceLabel;
  DoubleSpinBox * _sourceEdit;
};

#endif // REFRACTIONTARGETWIDGET_H
