/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-05-18
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAGNETOTELLURICTARGETWIDGET_H
#define MAGNETOTELLURICTARGETWIDGET_H

#include <QGpGuiWave.h>

class MagnetoTelluricTargetWidget : public CurveBrowser, public WidgetRect
{
  Q_OBJECT
public:
  MagnetoTelluricTargetWidget(QWidget * parent=nullptr);
  ~MagnetoTelluricTargetWidget();

  void initLayer(LineLayer * curveLayer);
  virtual void load();

  QList<MagnetoTelluricCurve> curves() const;
  void addCurve(const MagnetoTelluricCurve& curve);
  void addCurves(const QList<MagnetoTelluricCurve>& curves);
protected:
  void resizeEvent(QResizeEvent * e);
private slots:
  void setComplexMode(int index);
private:
  MagnetoTelluricCurve& curve(int index) const;
  void loadTarget(QString fileName);

  QComboBox * _complexMode;
  MagnetoTelluricPointOptions * _pointOptions;
};

#endif // MAGNETOTELLURICTARGETWIDGET_H
