/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SELECTPSVIEWER_H
#define SELECTPSVIEWER_H

#include <QGpGuiTools.h>
#include "ui_SelectPSViewer.h"
#include "PSViewer.h"

class Dinver;
class InversionThread;

class SelectPSViewer : public Dialog, public Ui::SelectPSViewer
{
  Q_OBJECT

public:
  SelectPSViewer(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  ~SelectPSViewer();

  PSViewer * result();
  void init(PSViewerList psViewerPtrList, InversionThread * models);

public slots:
  void on_isNewViewer_toggled(bool);
  void on_isAddToViewer_toggled(bool);
  void on_isNewViewer_clicked();
  void on_isAddToViewer_clicked();
protected:
  PSViewerVector _selectedViewers;

};

#endif // QTBDIALOG_SELECTPSVIEWER_H
