/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-01
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpGuiTools.h>

#include "LaunchThreadDelegate.h"
#include "InversionThread.h"
#include "WindowEnvironment.h"
#include "MainWindow.h"

QWidget * LaunchThreadDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                             const QModelIndex & index) const
{
  TRACE;
  switch (index.column()) {
  case 0: {
      InversionThread * t=WindowEnvironment::window(parent)->threads().at(index.row());
      if(!t->isRunning()) {
        QLineEdit * w=new QLineEdit(parent);
        return w;
      } else return 0;
    }
  case 5: {
      QSpinBox * w=new QSpinBox(parent);
      w->setMinimum(0);
      w->setMaximum(INT_MAX);
      return w;
    }
  case 6: {
      QSpinBox * w=new QSpinBox(parent);
      w->setSuffix( " %" );
      w->setMinimum(0);
      w->setMaximum(100);
      return w;
    }
  default: {
      QSpinBox * w=new QSpinBox(parent);
      w->setMinimum(0);
      w->setMaximum(999999);
      return w;
    }
  }
  return 0;
}

QSize LaunchThreadDelegate::sizeHint (const QStyleOptionViewItem & option, const QModelIndex & index) const
{
  TRACE;
  return QItemDelegate::sizeHint(option, index);
}

void LaunchThreadDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
{
  TRACE;
  switch (index.column()) {
  case 0: {
      QLineEdit * w=qobject_cast<QLineEdit *>(editor);
      ASSERT(w);
      w->setText(index.model() ->data(index).toString());
      w->selectAll();
      break;
    }
  default: {
      QSpinBox * w=qobject_cast<QSpinBox *>(editor);
      ASSERT(w);
      w->setValue(index.model() ->data(index).toInt());
      break;
    }
  }
}

void LaunchThreadDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                        const QModelIndex &index) const
{
  TRACE;
  switch (index.column()) {
  case 0: {
      QLineEdit * w=qobject_cast<QLineEdit *>(editor);
      ASSERT(w);
      if(w->isModified() && model->data(index)!=w->text()) {
        model->setData(index, w->text());
        emit dataChanged();
      }
      break;
    }
  default: {
      QSpinBox * w=qobject_cast<QSpinBox *>(editor);
      ASSERT(w);
      if(model->data(index)!=w->value()) {
        model->setData(index, w->value());
        emit dataChanged();
      }
      break;
    }
  }
}
