/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-10-29
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SLOPEESTIMATOR_H
#define SLOPEESTIMATOR_H

#include "LineLayer.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT SlopeEstimator : public LineLayer
{
  Q_OBJECT
  Q_PROPERTY(QString font READ fontString WRITE setFontString SCRIPTABLE true)
  Q_PROPERTY(QString format READ formatString WRITE setFormat SCRIPTABLE true)
public:
  SlopeEstimator(AxisWindow * parent=nullptr);

  virtual const QString& xml_tagName() const {return xmlSlopeEstimatorTag;}
  static const QString xmlSlopeEstimatorTag;

  enum Format {DegreesFromX, DegreesFromY, RatioYOverX, RatioXOverY};

  Format format() const {return _format;}
  QString formatString() const;
  void setFormat(Format f) {_format=f;}
  void setFormat(QString f);

  QString fontString() const {return _textFont.toString();}
  void setFontString(QString fs) {_textFont.fromString(fs);}
protected:
  virtual void paintData(const LayerPainterRequest& lp, QPainter& p, double dotpercm) const;
  virtual void paintText(const LayerPainterRequest& lp, double dotpercm);
private:
  QFont _textFont;
  Format _format;
  QList<QPainterPath> _textPaths;
  mutable Mutex _textPathsMutex;
};

} // namespace SciFigs

#endif // SLOPEESTIMATOR_H
