/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-09-26
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LISTINTERPOLE_H
#define LISTINTERPOLE_H

#include <QGpCoreMath.h>
#include <QGpGuiTools.h>

#include "ui_ListInterpole.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

class Legend;

class SCIFIGS_EXPORT ListInterpole : public Dialog, private Ui::ListInterpole
{
  Q_OBJECT
public:
  ListInterpole(QWidget * parent=0) : Dialog(parent) {setupUi(this);}

  void setColors(const ColorPalette &pal);
  void setValues(const ColorMap& pal);

  int fromIndex() const;
  int toIndex() const;
private slots:
  void on_firstEntry_clicked();
  void on_lastEntry_clicked();
};

} // namespace SciFigs

#endif // LISTINTERPOLE_H
