/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-05-30
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTLINE_H
#define ABSTRACTLINE_H

#include <QGpCoreMath.h>

#include "SciFigsDLLExport.h"
#include "Symbol.h"

namespace SciFigs {

class SCIFIGS_EXPORT AbstractLine : public XMLClass
{
public:
  AbstractLine() {_selected=false; _visible=true; _editable=true;}
  virtual ~AbstractLine() {}

  virtual const QString& xml_tagName() const {return xmlAbstractLineTag;}
  static const QString xmlAbstractLineTag;

  virtual AbstractLine * clone() const=0;
  virtual void operator=(const AbstractLine& o);

  virtual int count() const=0;
  virtual void clear()=0;
  virtual void append()=0;
  virtual void insert(int index)=0;
  virtual void removeLast()=0;
  virtual bool isValid(int) const {return true;}
  virtual void setValid(int, bool) {}
  virtual bool isSorted() const=0;
  virtual void checkSort() {}
  virtual void indexRange(double xMin, double xMax, int& indexMin, int& indexMax) const {
    Q_UNUSED(xMin) Q_UNUSED(xMax) indexMin=0; indexMax=count()-1;
  }
  virtual Point point(int index, const CurvePointOptions * options) const=0;
  virtual void setX(int index, double v)=0;
  virtual void setY(int index, double v, const CurvePointOptions * options=nullptr)=0;
  virtual void setZ(int index, double v, const CurvePointOptions * options=nullptr)=0;

  virtual QString toString(int index, const CurvePointOptions * options) const {return point(index, options).toString(20);}
  virtual bool fromString(int index, const StringSection& str, const QChar *& ptr, const CurvePointOptions * options);

  void setPen(const Pen& p) {_pen=p;}
  const Pen& pen() const {return _pen;}

  void setSymbol(const Symbol& s) {_symbol=s;}
  const Symbol& symbol() const {return _symbol;}

  bool isSelected() const {return _selected;}
  void setSelected(bool s) {_selected=s;}

  bool isVisible() const {return _visible;}
  void setVisible(bool v) {_visible=v;}

  bool isEditable() const {return _editable;}
  void setEditable(bool e) {_editable=e;}
protected:
  Pen _pen;
  Symbol _symbol;
  uint _selected: 1;
  uint _visible: 1;
  uint _editable: 1;
  uint _unused: 29;
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
};

} // namespace SciFigs

#endif // ABSTRACTLINE_H
