/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-25
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "XMLEditor.h"
#include "XMLItem.h"
#include "Application.h"

namespace QGpGuiTools {

  QWidget * XMLEditorDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                                const QModelIndex & ) const
  {
    TRACE;
    QLineEdit * w=new QLineEdit(parent);
    return w;
  }

  void XMLEditorDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
  {
    TRACE;
    QLineEdit * w= qobject_cast<QLineEdit *>(editor);
    if( !w) return;
    w->setText(index.model() ->data(index).toString());
    w->selectAll();
  }

  void XMLEditorDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                           const QModelIndex &index) const
  {
    TRACE;
    QLineEdit * w=qobject_cast<QLineEdit *>(editor);
    if( !w) return;
    model->setData(index, w->text());
  }

  /*!
    \class XMLEditor XMLEditor.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  XMLEditor::XMLEditor(QWidget * parent)
      : QTreeView(parent)
  {
    TRACE;
    XMLItem * model=new XMLItem(this);
    connect(model, SIGNAL(includeChanged(const QModelIndex&)),
            this, SLOT(includeChanged(const QModelIndex&)));
    setModel(model);
    setItemDelegate( new XMLEditorDelegate(this) );
    setSelectionBehavior( QAbstractItemView::SelectItems );
    setSelectionMode( QAbstractItemView::ExtendedSelection );
    setEditTriggers( QAbstractItemView::AllEditTriggers );
    setAlternatingRowColors(true);

    _menu=new QMenu(this);
    setContextMenuPolicy(Qt::DefaultContextMenu);
  }

  /*!
    Description of destructor still missing
  */
  XMLEditor::~XMLEditor()
  {
    TRACE;
  }

  XMLItem * XMLEditor::model() const
  {
    TRACE;
    return static_cast<XMLItem *>(QTreeView::model());
  }

  void XMLEditor::contextMenuEvent(QContextMenuEvent * e)
  {
    TRACE;
    _menu->clear();
    _menu->addAction(tr("Exclude"), this, SLOT(excludeSelectedItems()));
    _menu->addAction(tr("Include"), this, SLOT(includeSelectedItems()));
    _menu->popup(viewport()->mapToGlobal(e->pos()));
  }

  void XMLEditor::excludeSelectedItems()
  {
    TRACE;
    setEnabled(false, model()->getSelection(*selectionModel()));
  }

  void XMLEditor::includeSelectedItems()
  {
    TRACE;
    setEnabled(true, model()->getSelection(*selectionModel()));
  }

  void XMLEditor::setEnabled(bool e, QList<XMLGenericItem *> itemList)
  {
    TRACE;
    XMLItem * m=model();
    for(QList<XMLGenericItem *>::Iterator it=itemList.begin(); it!=itemList.end(); ++it) {
      XMLGenericItem * item=*it;
      if(item->parent()) {  // Protect root item from disabling
        item->setEnabled(e);
        if(item->childrenCount()>0) {
          includeChanged(m->index(item));
        }
      }
    }
  }

  void XMLEditor::includeChanged(const QModelIndex& index)
  {
    TRACE;
    XMLItem * m=model();
    XMLGenericItem * xml=m->xmlItem(index);
    if(xml->isEnabled()) {
      expand(index);
    } else {
      collapse(index);
    }
  }

} // namespace QGpGuiTools
