/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-04-02
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PROPERTYTABSETTINGS_H
#define PROPERTYTABSETTINGS_H

#include <QtGui>

namespace QGpGuiTools {

class PropertyTabSettings
{
public:
  PropertyTabSettings() {_scrollPosition=0;}
  PropertyTabSettings(const PropertyTabSettings& o) {
    _state=o._state;
    _scrollPosition=o._scrollPosition;
  }

  void setState(const QByteArray& s) {_state=s;}
  QByteArray state() const {return _state;}

  void setScrollPosition(int p) {_scrollPosition=p;}
  int scrollPosition() const {return _scrollPosition;}
private:
  QByteArray _state;
  int _scrollPosition;
};

} // namespace QGpGuiTools

#endif // PROPERTYTABSETTINGS_H
