/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-03-31
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "PropertyCategory.h"
#include "PropertyWidget.h"
#include "PropertyTab.h"
#include "ExpandTabWidget.h"

namespace QGpGuiTools {

  /*!
    \class PropertyCategory PropertyCategory.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  PropertyCategory::PropertyCategory()
  {
  }

  /*!
    Description of destructor still missing
  */
  PropertyCategory::~PropertyCategory()
  {
    for(QHash<uint, PropertyTab *>::iterator it=_tabs.begin(); it!=_tabs.end(); it++) {
      delete it.value();
    }
  }

  PropertyTab * PropertyCategory::find(uint tab)
  {
    QHash<uint, PropertyTab *>::iterator it=_tabs.find(tab);
    if(it!=_tabs.end()) {
      return it.value();
    } else {
      return 0;
    }
  }

  void PropertyCategory::setEditor(ExpandTabWidget * editor)
  {
    for(QHash<uint, PropertyTab *>::iterator it=_tabs.begin(); it!=_tabs.end(); it++) {
      editor->addWidget(it.value()->title(), it.value()->widget());
    }
  }

  PropertyTab * PropertyCategory::addTab(uint tab, QString title, PropertyWidget * w, PropertyItem * item)
  {
    PropertyTab * t=new PropertyTab;
    t->setTitle(title);
    t->setWidget(w);
    _tabs.insert(tab, t);
    t->addReference(item);
    return t;
  }

  void PropertyCategory::removeTab(uint tab, PropertyItem * item, ExpandTabWidget * editor)
  {
    QHash<uint, PropertyTab *>::iterator it=_tabs.find(tab);
    if(it!=_tabs.end()) {
      it.value()->removeReference(item);
      if(!it.value()->hasReference()) {
        bool deleteTab=true;
        if(editor) {
          if(editor->isDocked(it.value()->widget()) ) {
            editor->takeWidget(it.value()->widget());
          } else {
            deleteTab=false;
          }
        }
        if(deleteTab) {
          delete it.value();
          _tabs.erase(it);
        }
      }
    }
  }

  void PropertyCategory::setValues()
  {
    for(QHash<uint, PropertyTab *>::iterator it=_tabs.begin(); it!=_tabs.end(); it++) {
      it.value()->setValues();
    }
  }

} // namespace QGpGuiTools
