/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-09-18
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "LoopProgressWidget.h"
#include "Application.h"

namespace QGpGuiTools {

/*!
  \class LoopProgressWidget LoopProgressWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
LoopProgressWidget::LoopProgressWidget(QWidget *parent)
    : QScrollArea(parent)
{
  TRACE;
  //::setWidgetColor(viewport(), Qt::gray);
  setWidgetResizable(true);
  setHorizontalScrollBarPolicy(Qt::ScrollBarAlwaysOff);
  connect(verticalScrollBar(), SIGNAL(sliderMoved(int)), this, SLOT(stopAutoScroll()));
  _layout=nullptr;
  _autoScroll=true;
}

/*!
  Description of destructor still missing
*/
LoopProgressWidget::~LoopProgressWidget()
{
  TRACE;
}

void LoopProgressWidget::setLoop(const QGpCoreTools::ParallelLoop * loop)
{
  TRACE;
  // Clear all progress widgets
  delete widget();
  _labelList.clear();
  _progressList.clear();
  // Create new ones
  QWidget * w=new QWidget(this);
  setWidget(w);
  _layout=new QVBoxLayout(w);
  // We setup the maximum number of possible parallel threads
  // Effectively some of them might not start according to system load
  int nProgress=loop->maximumThreadCount();
  for(int i=0; i<nProgress; i++ ) {
    QLabel * l=new QLabel(w);
    _labelList.append(l);
    QVBoxLayout * progressLayout=new QVBoxLayout;
    progressLayout->addWidget(l);
    QProgressBar * p=new QProgressBar(w);
    _progressList.append(p);
    progressLayout->addWidget(p);
    progressLayout->setMargin(0);
    _layout->addLayout(progressLayout);
  }
  _layout->addStretch();
  connect(loop, SIGNAL(statusChanged(int, QString)), this, SLOT(setStatus(int, QString)));
  connect(loop, SIGNAL(progressInit(int, int)), this, SLOT(initProgress(int, int)));
  connect(loop, SIGNAL(progressChanged(int, int)), this, SLOT(setProgress(int, int)));
}

void LoopProgressWidget::setStatus(int processIndex, QString msg)
{
  if(processIndex<_labelList.count()) {
    QLabel * l=_labelList.at(processIndex);
    l->setText(msg);
  }
}

void LoopProgressWidget::initProgress(int processIndex, int maximumValue)
{
  if(processIndex<_progressList.count()) {
    QProgressBar * p=_progressList.at(processIndex);
    p->setValue(0);
    p->setMaximum(maximumValue);
    if(!_autoScroll && !p->visibleRegion().isEmpty()) {
      _autoScroll=true;
    }
    if(_autoScroll) {
      ensureWidgetVisible(p);
    }
  }
}

void LoopProgressWidget::stopAutoScroll()
{
  _autoScroll=false;
}

void LoopProgressWidget::setProgress(int processIndex, int value)
{
  if(processIndex<_progressList.count()) {
    QProgressBar * p=_progressList.at(processIndex);
    p->setValue(value);    
  }
}

} // namespace QGpGuiTools
