/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-07-01
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef LOGVIEW_H
#define LOGVIEW_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

class QGPGUITOOLS_EXPORT LogView : public QTextBrowser, public AbstractStream
{
  Q_OBJECT
public:
  LogView(QWidget * parent=nullptr);

  void remove();

  void setMinimumLineCount(int n) {_minimumLineCount=n;}
  int minimumLineCount() const {return _minimumLineCount;}

  void operator=(LogView& o);
  void append(const QString& text) {send(0, text);}

  virtual ClassId classId() const {return LogViewId;}
  virtual QSize minimumSizeHint() const {return sizeHint();}
  virtual QSize sizeHint() const;
public slots:
  void flushBuffer();
  void clear();
protected:
  void contextMenuEvent(QContextMenuEvent * e);
  virtual void sendToStream(const QString& val);
  virtual void flushStream();
private slots:
  void wakeUp();
signals:
  void bufferReady();
private:
  int _minimumLineCount;
  Mutex _mutex;
  QString _buffer;
  QTimer _clock;
};

} // namespace QGpGuiTools

#endif // LOGVIEW_H
