/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-10-23
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "ColorHistogram.h"

namespace QGpGuiTools {

ColorHistogram::ColorHistogram(QRgb * colors, int * values, int num, QWidget *parent) :
    QWidget(parent, Qt::Window),
    sBar(Qt::Vertical,this)
{
  TRACE;
  setAttribute(Qt::WA_DeleteOnClose);
  _colors=colors;
  _numColors=num;
  _values=values;
  _maxVal=0;
  for(int i=0;i < _numColors;i++ ) {
    if(_values[ i ] > _maxVal) _maxVal=_values[ i ];
  }
  sBar.setMinimum(0);
  sBar.setMaximum(_numColors - 1);
  sBar.setSingleStep(1);
  sBar.setPageStep(10);
  sBar.setValue(0);
  connect (&sBar, SIGNAL(valueChanged( int) ), this, SLOT(scrollChanged( int) ));
  setGeometry(50, 50, 400, 400);
}

ColorHistogram::~ColorHistogram()
{
  TRACE;
  delete [] _values;
  delete [] _colors;
}

void ColorHistogram::resizeEvent(QResizeEvent * )
{
  TRACE;
  sBar.setGeometry(0, 0, 16, height());
}

void ColorHistogram::paintEvent(QPaintEvent * )
{
  TRACE;
  int i=sBar.value();
  int maxi=i + height()/COLOR_HEIGHT + 1;
  QPainter p(this);
  p.fillRect(0, 0, width(), height(), Qt::white);
  int y=0;
  int dx0=16 + 6 * TEXT_WIDTH;
  int dx1=dx0 + COLOR_WIDTH;
  int dx=width() - dx0;
  QString str( "%1" );
  while(i < maxi && i < _numColors) {
    QColor col(_colors[ i ] );
    int h, v, s;
    col.getHsv(&h, &s, &v);
    p.drawText(16, y + COLOR_HEIGHT, str.arg(col.red()) );
    p.drawText(16 + TEXT_WIDTH, y + COLOR_HEIGHT, str.arg(col.green()) );
    p.drawText(16 + 2 * TEXT_WIDTH, y + COLOR_HEIGHT, str.arg(col.blue()) );
    p.drawText(16 + 3 * TEXT_WIDTH, y + COLOR_HEIGHT, str.arg(h) );
    p.drawText(16 + 4 * TEXT_WIDTH, y + COLOR_HEIGHT, str.arg(s) );
    p.drawText(16 + 5 * TEXT_WIDTH, y + COLOR_HEIGHT, str.arg(v) );
    p.setPen(QColor( _colors[ i ] ));
    p.setBrush(QColor( _colors[ i ] ));
    p.drawRect(dx0, y, COLOR_WIDTH, COLOR_HEIGHT);
    int y2=y + (COLOR_HEIGHT >> 2);
    p.setPen(QPen( Qt::black, 2) );
    p.drawLine(dx1, y2, dx1 + _values[ i ] * dx/_maxVal, y2);
    i++;
    y += COLOR_HEIGHT;
  }
}

void ColorHistogram::scrollChanged(int)
{
  TRACE;
  update();
}

} // namespace QGpGuiTools
