/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-01-05
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Attachments.h"

namespace QGpGuiTools {

/*!
*/
Attachments::Attachments(QWidget* parent, Qt::WindowFlags fl)
    : Dialog(parent, fl)
{
  TRACE;
    setupUi(this);

}

/*!
*/
Attachments::~Attachments()
{
  TRACE;
}


void Attachments::setFileList(QStringList files)
{
  TRACE;
  fileList->addItems(files);
}

QStringList Attachments::getFileList()
{
  TRACE;
  QStringList l;
  int n=fileList->count();
  for(int i=0;i<n;i++) {
    l.append(fileList->item(i)->text());
  }
  return l;
}

void Attachments::on_addFile_clicked()
{
  TRACE;
  QStringList fileNames=Message::getOpenFileNames("Add attachments");
  if(!fileNames.isEmpty()) fileList->addItems(fileNames);
}

void Attachments::on_removeFile_clicked()
{
  TRACE;
  for(int i=fileList->count()-1;i>=0;i--) {
    if(fileList->item(i)->isSelected()) delete fileList->takeItem(i);
  }
}

} // namespace QGpGuiTools
