/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-02-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CURVESELECTOR_H
#define CURVESELECTOR_H

#include <QGpGuiTools.h>

#include "ui_CurveSelector.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

  class CurveProperties;

  class QGPGUIMATH_EXPORT CurveSelector : public Dialog, private Ui::CurveSelector
  {
    Q_OBJECT
  public:
    CurveSelector(QWidget * parent=nullptr);

    void addGroup(const QString& g);
    void addCurve(CurveProperties * p);
    void selectAll();

    QList<CurveProperties *> selectedCurves();
  };

} // namespace QGpGuiMath

#endif // CURVESELECTOR_H
