/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-10-13
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CURVEBROWSERVALIDATE_H
#define CURVEBROWSERVALIDATE_H

#include <QGpGuiTools.h>

#include "ui_CurveBrowserValidate.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT CurveBrowserValidate : public Dialog, public Ui::CurveBrowserValidate
  {
    Q_OBJECT
  public:
    CurveBrowserValidate(QWidget * parent=nullptr);

    void setCurveLimits(double min, double max) {_curveMin=min; _curveMax=max;}
    void setAxisNames(QString linearName, QString inversedName);
  private slots:
    void on_inversedBut_toggled(bool);
    void on_autoMin_clicked();
    void on_autoMax_clicked();
  private:
    double _curveMin, _curveMax;
  };

} // namespace QGpGuiMath

#endif // CURVEBROWSERVALIDATE_H

