/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-10-03
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ELLIPTICITYFACTORY_H
#define ELLIPTICITYFACTORY_H

#include "DispersionFactory.h"
#include "Ellipticity.h"
#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT EllipticityFactory : public ModalFactory
{
  TRANSLATIONS("EllipticityFactory")
public:
  EllipticityFactory();
  ~EllipticityFactory();

  Ellipticity * signedValues() {return _signedValues;}
  Ellipticity * absoluteValues() {return _absoluteValues;}

  double peakMisfit(const RealStatisticalValue& val, DispersionFactory& disp, const Seismic1DModel * model);

  virtual void setMode (const Mode& m);
  virtual const RealValue * mode(const Mode& m) const;
  virtual int storageCount() const {return 1;} // Used only in DRReportBlock::writeFactory()
  inline virtual ModalStorage * storage(int) const;
protected:
  virtual ModalStorage * newStorage(int nModes) {return new Ellipticity(nModes, x());}
private:
  Ellipticity * _signedValues;
  Ellipticity * _absoluteValues;
};

inline ModalStorage * EllipticityFactory::storage(int storageIndex) const
{
  TRACE;
  switch (storageIndex) {
  case 1:
    return _absoluteValues;
  default:
    return _signedValues;
  }
}

} // namespace QGpCoreWave

#endif // ELLIPTICITYFACTORY_H
