/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-02-04
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "AutocorrDispersion.h"

namespace QGpCoreWave {

/*!
  \class AutocorrDispersion AutocorrDispersion.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Calculates y(k)=verticalAutocorrelation(k)-autocorrRef.
*/
double AutocorrDispersion::y(double k)
{
  TRACE;
  if(isThinRing()) {
    return verticalThinRing(k)-_autocorrRef;
  } else {
    return verticalThickRing(k)-_autocorrRef;
  }
}

/*!
  Returns all the dispersion curve solutions for \a autocorr between \a kmin and \a kmax.
  The returned values are slowness sorted in ascending order.
*/
QVector<double> AutocorrDispersion::dispersion(const FactoryPoint& autocorr, double kmin, double kmax)
{
  TRACE;
  QVector<double> results;
  RootSolver<AutocorrDispersion> solver(this);
  solver.setPrecision(1e-7);
  solver.setRelativeStep(0.1);
  _autocorrRef=autocorr.y(0);
  solver.setPolarity(kmax);
  double invOmega=0.5/(M_PI * autocorr.x());
  while(solver.searchDownSlope(kmax, kmin, kmax) ) {
    solver.neville();
    kmax=solver.lower();
    results.prepend(kmax*invOmega);
    solver.inversePolarity();
  }
  return results;
}

} // namespace QGpCoreWave
