/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-11-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ARRIVALTIME_H
#define ARRIVALTIME_H

#include <QGpCoreMath.h>

#include "QGpCoreWaveDLLExport.h"

namespace QGpCoreWave {

class QGPCOREWAVE_EXPORT ArrivalTime : public RealStatisticalPoint
{
public:
  ArrivalTime() {}
  ArrivalTime(double x, double time, double timeDev);
  virtual ~ArrivalTime() {}

  virtual const QString& xml_tagName() const {return xmlArrivalTimeTag;}
  static const QString xmlArrivalTimeTag;
};

inline ArrivalTime::ArrivalTime(double x, double time, double timeDev)
   : RealStatisticalPoint(x, time)
{
  TRACE;
  setStddev(timeDev);
}

} // namespace QGpCoreWave

#endif // ARRIVALTIME_H
