/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-12-19
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef HISTOGRAM_H
#define HISTOGRAM_H

#include "QGpCoreMathDLLExport.h"
#include "Curve.h"
#include "Rect.h"
#include "StatisticalValue.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Histogram : private Curve<Point2D>
  {
  public:
    Histogram();
    ~Histogram();

    void setSampling(int n, double min, double max, SamplingOptions sampling);
    SamplingOptions sampling() const {return _sampling;}

    void addValue(double v);
    void clear();
    void normalize();

    ::QVector<Rect> boxes() const;
    Rect limits() const;

    RealStatisticalValue mean() const;
    RealStatisticalValue median() const;
    RealStatisticalValue mode() const;

    int countClasses() const {return Curve<Point2D>::count();}
    const Point2D& classAt(int index) const {return Curve<Point2D>::at(index);}
    double lastClass() const {return _lastClass;}

    void clearClasses() {Curve<Point2D>::clear();}
    void addClass(const Point2D& c) {Curve<Point2D>::append(c);}
    void setLastClass(double c) {_lastClass=c;}

    double variance(double average) const;
  private:
    SamplingOptions _sampling;
    double _lastClass;
  };

} // namespace QGpCoreMath

#endif // HISTOGRAM_H
