/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-11-12
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DIRECTIONALSEARCH_H
#define DIRECTIONALSEARCH_H

#include "QGpCoreMathDLLExport.h"
#include "FunctionSearch.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT DirectionalSearch : public FunctionSearch
{
public:
  DirectionalSearch();
  ~DirectionalSearch();

  void setAzimuth(double azimuth);
  void setGrid(double minR, double maxR, double dR);

  void globalMax(double absThres=0.0);
  void localMax(int nMax, double absThres=0.0, double relThres=0.0);

  double value(double r) const {return _function->value(Point2D(_cx*r, _sy*r));}
protected:
  double _cx, _sy;
  int _nr;
  double * _r;
private:
  double refineMax(double minR, double maxR, double maxVal);
  inline void checkForMax(double r, double& maxVal, double& maxR);
};

} // namespace QGpCoreMath

#endif // DIRECTIONALSEARCH_H
