/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-04-11
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ABSTRACTNUMERICALKEY_H
#define ABSTRACTNUMERICALKEY_H

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

class AbstractNumericalCache;

class QGPCOREMATH_EXPORT AbstractNumericalKey
{
public:
  AbstractNumericalKey() {}
  virtual ~AbstractNumericalKey() {}

  virtual bool operator==(const AbstractNumericalKey& o)=0;
  virtual int hash() const=0;
  virtual AbstractNumericalCache * createCache()=0;

  virtual int id() const=0;
  static int newId() {return _newId++;}
private:
  static int _newId;
};

#define DECLARE_NUMERICALKEY(_KeyClass_) \
  public: \
    virtual int id() const {return _id;} \
  private: \
    friend class _KeyClass_##Register; \
    static int _id;

#define IMPLEMENT_NUMERICALKEY(_KeyClass_) \
int _KeyClass_::_id=0; \
class _KeyClass_##Register \
{ \
public: \
  _KeyClass_##Register() {_KeyClass_::_id=AbstractNumericalKey::newId();} \
}; \
_KeyClass_##Register autoRegister##_KeyClass_;

} // namespace QGpCoreMath

#endif // ABSTRACTNUMERICALKEY_H
