/***************************************************************************
**
**  This file is part of QGpCompatibility.
**
**  QGpCompatibility is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCompatibility is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-04-28
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPATDISPERSION_H
#define COMPATDISPERSION_H

#include <QGpCoreWave.h>
#include "QGpCompatibilityDLLExport.h"
#include "CompatMultiModalCurves.h"

namespace QGpCompatibility {

class CompatEllipticity;

class CompatDispersion: public CompatMultiModalCurves
{
public:
  // Default constructor
  CompatDispersion(): CompatMultiModalCurves() {_relPrec=1e-7;}
  // Allocates an empty structure
  CompatDispersion(int modesCount,int omegasCount)
    : CompatMultiModalCurves(modesCount, omegasCount) {_relPrec=1e-7;}
  // Copy constructor
  CompatDispersion(const CompatMultiModalFrequency *o)
    : CompatMultiModalCurves(o) {_relPrec=1e-7;}
  // Copy constructor changing the number of modes
  CompatDispersion(const CompatMultiModalFrequency *o,int modesCount)
    : CompatMultiModalCurves(o, modesCount) {_relPrec=1e-7;}
  // Copy constructor
  CompatDispersion(const CompatMultiModalCurves *o)
    : CompatMultiModalCurves(o) {_relPrec=1e-7;}
  // Copy constructor changing the number of modes
  CompatDispersion(const CompatMultiModalCurves * o,int modesCount)
    : CompatMultiModalCurves(o, modesCount,0) {_relPrec=1e-7;}
  
  // Returns the omega count for mode m where phase velocity is different from 0
  int omegasCount (int m) const;
  // Returns the omega count
  int omegasCount () const {return _omegasCount;}
  // Print the dispersion curve in Herrmann's format
  void exportHerrmann(char * fileName);
  // Check the slopes of the last dispersion curve calculated, returns true if OK, maxSlowness must be the mimimum Shear Slowness of the model used for calculations. An error is reported if a constant slowness is observed at a lower slowness.
  bool checkSlopes(double maxSlowness);
  // Set all dispersion curves to zero 
  void resetValues();
  void setPrecision(double prec) {_relPrec=prec;}
  void clear() {CompatMultiModalCurves::clear(0);}
private:
  double _minSlow, _maxSlow;
  double _relPrec;
};

} // namespace QGpCompatibility

#endif // COMPATDISPERSION_H
