/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-01-27
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <HVCore.h>

#include "StationLine.h"

namespace HVGui {

/*!
  \class StationLine StationLine.h
  \brief Line object to represent a station on a map

  Full description of class still missing
*/

AbstractLine * StationLine::clone() const
{
  StationLine * l=new StationLine;
  *l=*this;
  return l;
}

void StationLine::operator=(const StationLine& o)
{
  _station=o._station;
  AbstractNameLine::operator=(o);
}

QString StationLine::name(int) const
{
  switch(_label) {
  case StationName:
    return _station->name();
  case PeakValue:
    if(_value.isValid()) {
      return QString::number(_value.value(), 'f', _labelPrecision);
    }
  case NoLabel:
    break;
  }
  return QString();
}

void StationLine::setValue(PeakSelection ps, CurveResults::PeakValue pv, int peakIndex)
{
  if(_station->peakCount()==0) {
    _value.setValid(false);
  } else {
    switch(ps) {
    case PeakNumber:
      if(peakIndex<_station->peakCount()) {
        _value.setValue(_station->peak(peakIndex, pv));
      } else {
        _value.setValid(false);
      }
      break;
    case PeakLowest:
      _value.setValue(_station->lowestPeak(pv));
      break;
    case PeakHighest:
      _value.setValue(_station->highestPeak(pv));
      break;
    case PeakMaximum:
      _value.setValue(_station->maximumAmplitudePeak(pv));
      break;
    }
  }
}

} // namespace HVGui
