/***************************************************************************
**
**  This file is part of HVGui.
**
**  HVGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  HVGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-03-29
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SETCATEGORY_H
#define SETCATEGORY_H

#include <QGpGuiTools.h>
#include "ui_SetCategory.h"
#include "HVGuiDLLExport.h"

namespace HVGui {

  class HVGUI_EXPORT SetCategory : public Dialog, private Ui::SetCategory
  {
    Q_OBJECT
  public:
    SetCategory(QWidget * parent=nullptr);

    void setCategoryNames(const QStringList& names);

    void setCurrentCategory(const QString& name) {categoryNameEdit->setEditText(name);}
    QString currentCategory() const {return categoryNameEdit->currentText();}
  };

} // namespace HVGui

#endif // SETCATEGORY_H
