/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-09-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PICKSPROPERTIES_H
#define PICKSPROPERTIES_H

#include <QGpGuiTools.h>

#include "ui_PicksProperties.h"
#include "GeopsyGuiDLLExport.h"
#include "PickLayer.h"

namespace GeopsyGui {

class GEOPSYGUI_EXPORT PicksProperties : public PropertyWidget, private Ui::PicksProperties
{
  Q_OBJECT
public:
  PicksProperties(QWidget* parent=0);

  virtual void setWidgets();
private slots:
  void on_picks_clicked(const QModelIndex& index);
  void on_defaultColors_clicked();
private:
  virtual PropertyValue::WidgetType determineCustomWidgetType(int pid, QWidget * w, QWidget * label);
};

} // namespace GeopsyGui

#endif // PICKSPROPERTIES_H
