/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-10-20
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ASCIISIGNALFORMATEDITOR_H
#define ASCIISIGNALFORMATEDITOR_H

#include <GeopsyCore.h>
#include <QGpGuiTools.h>

#include "ui_AsciiSignalFormatEditor.h"
#include "GeopsyGuiDLLExport.h"

namespace GeopsyGui {

class AsciiSignalRulesWidget;
class AsciiSignalComponentsWidget;

class GEOPSYGUI_EXPORT AsciiSignalFormatEditor : public Dialog, private Ui::AsciiSignalFormatEditor
{
  Q_OBJECT
public:
  AsciiSignalFormatEditor(QWidget * parent=0, Qt::WindowFlags f=Qt::Widget);
  ~AsciiSignalFormatEditor();

  void setFormat(const AsciiSignalFormat& f);
  const AsciiSignalFormat& format() const {return _format;}
private slots:
  void on_nameEdit_textChanged();
  void on_suffixEdit_editingFinished();
  void on_rulesButton_clicked();
  void on_componentsButton_clicked();
  void on_exampleButton_clicked();
  void on_headerType_currentIndexChanged(int);
  void on_headerPattern_textChanged(const QString& text);
  void on_headerCount_valueChanged(int value);
  void on_timeFormat_textChanged(const QString& text);
  void on_exampleEdit_textChanged();
  void on_quotes_stateChanged();
  void on_skipEmpty_stateChanged();
  void on_hexadecimal_stateChanged();
  void on_helpButton_clicked();
  void on_loadButton_clicked();
  void on_separators_currentTextChanged(const QString &);
  void readerReady();
private:
  AsciiSignalFormat _format;
  AsciiSignalRulesWidget * _rules;
  AsciiSignalComponentsWidget * _components;
  AsciiSignalFormatReader * _reader;
};

} // namespace GeopsyGui

#endif // ASCIISIGNALFORMATEDITOR_H
