/***************************************************************************
**
**  This file is part of GeopsyGui.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-08-04
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef Qtb_ARRAYDEFINITION_H
#define Qtb_ARRAYDEFINITION_H

#include <QGpGuiTools.h>
#include "ui_ArrayDefinition.h"

namespace GeopsyGui {

class ArrayDefinition : public Dialog, public Ui::ArrayDefinition
{
  Q_OBJECT
public:
  ArrayDefinition(QWidget * parent=nullptr);
  ~ArrayDefinition();
  
  void setCurrentGroup(QString groupName);
  void setStartTime(QString t);
  QString getStartTime();
  void setEndTime(QString t);
  QString getEndTime();
private slots:
  void on_capSettingsBrowse_clicked();
  void on_groupList_currentIndexChanged (QTreeWidgetItem * current, QTreeWidgetItem * previous);
  void on_wdBrowse_clicked(); 
};
  
} // namespace GeopsyGui

#endif // ARRAYDEFINITION_H
