/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-01-28
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TimeWindowList.h"

namespace GeopsyCore {

  /*!
    \class TimeWindowList TimeWindowList.h
    \brief A TimeRange with a color.

    Full description of class still missing
  */

  const QString TimeWindowList::xmlTimeWindowListTag="TimeWindowList";

  /*!
    Cannot use the copy constructor of TimeRangeList because
    virtual mechanism to create new range is not yet ready (in constructor)
  */
  TimeWindowList::TimeWindowList(const TimeWindowList& o, int firstIndex)
    : TimeRangeList(), XMLClass(), _defaultColor(200, 255, 193)
  {
    int n=o.count();
    for(int i=firstIndex;i<n;i++) {
      const TimeRange& r=o.at(i);
      append(newTimeRange(r.start(), r.end()));
    }
  }

  /*!
    This function must be re-impleted in all subclass. Virtual mechanism for deleteTimeRange() does
    not work for destructors. In each subclass, the list must be cleared to avoid re-delete in lower
    level classes.
  */
  TimeWindowList::~TimeWindowList()
  {
    TRACE;
    for(iterator it=begin(); it!=end(); ++it) {
      delete static_cast<TimeWindow *>(*it);
    }
    internalClear();
  }

  void TimeWindowList::resetColors()
  {
    TRACE;
    int n=count();
    for(int i=0; i<n; i++) {
      TimeWindow& w=at(i);
      w.setColor(_defaultColor);
    }
  }

  void TimeWindowList::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
  {
    TRACE;
    int n=count();
    for(int i=0; i<n; i++) {
      const TimeWindow& w=at(i);
      XMLSaveAttributes att;
      w.xml_attributes(att, context);
      writeProperty(s, TimeWindow::xmlTimeWindowTag, att);
    }
  }

  XMLMember TimeWindowList::xml_member(XML_MEMBER_ARGS)
  {
    TRACE;
    Q_UNUSED(context)
    Q_UNUSED(attributes)
    if(tag==TimeWindow::xmlTimeWindowTag) {
      return XMLMember(0);
    }
    return XMLMember(XMLMember::Unknown);
  }

  bool TimeWindowList::xml_setProperty(XML_SETPROPERTY_ARGS)
  {
    TRACE;
    Q_UNUSED(content)
    Q_UNUSED(tag)
    if(memberID==0) {
      TimeWindow& w=addOne();
      if(w.xml_setAttributes(attributes, context)) {
        return true;
      } else {
        App::freeze(true);
        remove(count()-1);
        App::freeze(false);
      }
    }
    return false;
  }

} // namespace GeopsyCore
