/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-11-30
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "TaperDelegate.h"
#include "DoubleSignal.h"

namespace GeopsyCore {

  /*!
    \class TaperDelegate TaperDelegate.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  TaperDelegate::TaperDelegate(const WindowFunctionParameters * p)
  {
    TRACE;
    _parameters=p;
  }

  /*!
    Description of destructor still missing
  */
  TaperDelegate::~TaperDelegate()
  {
    TRACE;
  }

  double TaperDelegate::correctionFactor(double start, double end, double samplingFrequency)
  {
    return correctionFactor(qRound(start*samplingFrequency),
                            qRound(end*samplingFrequency)-1);
  }

  double TaperDelegate::correctionFactor(int windowFirstSample, int windowLastSample)
  {
#ifdef COMPATIBILITY_2_5_0
    WindowFunction func(windowLastSample-windowFirstSample+2, *_parameters);
#else
    WindowFunction func(windowLastSample-windowFirstSample+1, *_parameters);
#endif
    return func.correctionFactor();
  }

  /*!
    Generate a a flat signal at 1 and apply current window
  */
  void TaperDelegate::test(int nSamples, int startIndex, int endIndex)
  {
    TRACE;
    DoubleSignal * sig=new DoubleSignal(nSamples);
    sig->initValues(1.0, 0, nSamples);
    LOCK_SAMPLES(double, sigSamples, sig)
      TaperDelegate::RealSample samples(sigSamples);
      apply(samples, 0, nSamples-1, startIndex, endIndex);
    UNLOCK_SAMPLES(sig)
    sig->debugPrint();
    delete sig;
  }

} // namespace GeopsyCore
