/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-08-26
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SYSCOMXMRHEADER_H
#define SYSCOMXMRHEADER_H

#include "SyscomHeader.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

#pragma pack(1)     // set alignment to 1 byte boundary

class GEOPSYCORE_EXPORT SyscomXmrHeader : public SyscomHeader
{
public:
  SyscomXmrHeader();

  DateTime startTime() const {return SyscomHeader::startTime(field.INT_TIME);}
  double countPerVolt(int channel) const {return SyscomHeader::countPerVolt(field.LSB[channel] );}

  union {
    char raw [256];
    struct {
      char UNUSED1[8];     // 0
      qint32 NB_SAMPLES;   // 8
      char UNUSED2[10];
      qint32 SYNC_OFFSET;  // 22
      Time SYNC_TIME;      // 26
      uchar SYNC_OK;
      qint16 INT_OFFSET;   // 33
      Time INT_TIME;       // 35
      char UNUSED3[13];
      qint16 SAMPLING;     // 54
      uchar NB_CHANNEL;    // 56
      char UNUSED4;
      qint16 SW_REVISION;  // 58
      char UNUSED5[11];
      char S_NUMBER[5];    // 71
      char SS_NUMBER[5];   // 76
      char UNUSED6[2];
      Lsb LSB[3];          // 83
      char CH_UNIT_X[5];     // 92
      char CH_UNIT_Y[5];
      char CH_UNIT_Z[5];
      char CH_NAME_X[3];     // 107
      char CH_NAME_Y[3];
      char CH_NAME_Z[3];
      char UNUSED7[140];     // 116
    } field;
  };
};

#pragma pack()   // restore original alignment

} // namespace GeopsyCore

#endif // SYSCOMXMRHEADER_H
